*Title: Securing Your activeCollab
*Slug: security

================================================================

Even if activeCollab is very safe to use, there are a couple of security measures which can be taken in order to reduce unnecessary risk.

<{sub}>Install activeCollab Behind the Document Root<{/sub}>

Installing activeCollab above the site root ensures that only files from the <{path}>/public<{/path}> folder are publicly available, while all other files are not accessible on the web. Even though the system encodes file names and comes with <{term}>.htaccess<{/term}> protection by default, for folders with sensitive data (<{path}>/upload<{/path}>, <{path}>/thumbnails<{/path}> and other), the best approach is to have them installed above the site root.

The following steps demonstrate how to install activeCollab with the <{path}>/public<{/path}> folder as a document root:

<{step num=1}>Define a virtual host where the http://intranet is mapped as public folder of your activeCollab setup. You can do that like this:
<{code}><VirtualHost *>
  ServerName intranet
  DocumentRoot /Library/WebServer/Documents/intranet/public
</VirtualHost><{/code}><{/step}>
<{step num=2}>Install activeCollab by visiting http://intranet and starting the activeCollab install utility.<{/step}>
<{step num=3}>When you confirm that activeCollab is running properly, open <{path}>config/config.php<{/path}> and add the following line to the block where all other configuration options are defined:

<{code}>define('PUBLIC_AS_DOCUMENT_ROOT', true);<{/code}><{/step}>

<{note title="Important Notes on the Installation behind the Document Root Process"}> 
- Sometimes the document root folders are not named public (it can be called public_html, web, etc). In that case, put the content of the <{path}>/public<{/path}> folder in your document root, run the installer and when you're done open <{path}>config/config.php<{/path}> and make sure that <{code}>PUBLIC_FOLDER_NAME<{/code}> is set to the correct value.
- If you are using <{term}>.htaccess<{/term}> fix to have <{page name="clean-url"}>100% clean URLs<{/page}>, you will need to put it in <{path}>/public<{/path}> folder and make appropriate changes to rewrite rules.
- Folders like <{path}>/cache<{/path}>, <{path}>/upload<{/path}>, <{path}>/logs<{/path}>, and similar, are protected by <{term}>.htaccess<{/term}> file with rules that restrict direct access to files located in these folders. Your server will need to be configured to allow overriding using .htaccess files. To learn more, read the <a href="http://httpd.apache.org/docs/1.3/configuring.html#htaccess">Apache documentation</a>.
<{/note}>

<{sub}>Use SSL Encryption<{/sub}>

activeCollab is protocol agnostic, so if your server supports SSL and has proper certificates installed, it will work on HTTPS as well as on HTTP. All you need to do is to **run the Installer on the proper protocol and your activeCollab will use the HTTPS URL automatically**.

If you already have activeCollab installed on HTTP, and decide to add the certificate later, you need to change the protocol in the <{path}>config/config.php<{/path}> file and change the line:

<{code}>define('ROOT_URL', 'http://example.com/public')<{/code}>

into:

<{code}>define('ROOT_URL', 'https://example.com/public')<{/code}>

After the update is made forget to delete files, except the <{term}>.htaccess<{/term}> files from the <{path}>/cache<{/path}> and <{path}>/compile<{/path}> folders of your activeCollab setup.